/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.animation.impl;

import com.alrex.parcool.client.animation.Animator;
import com.alrex.parcool.client.animation.PlayerModelRotator;
import com.alrex.parcool.client.animation.PlayerModelTransformer;
import com.alrex.parcool.common.action.impl.Dive;
import com.alrex.parcool.common.capability.impl.Parkourability;
import net.minecraft.world.entity.player.Player;

public class DiveAnimator
extends Animator {
    private final double startYSpeed;
    private float oldFactor = 0.0f;

    public DiveAnimator(double startYSpeed) {
        this.startYSpeed = startYSpeed;
    }

    private float getFactor(double yMovement) {
        return (float)(-2.0 * Math.atan((yMovement - this.startYSpeed) / this.startYSpeed) / Math.PI);
    }

    @Override
    public boolean shouldRemoved(Player player, Parkourability parkourability) {
        return !parkourability.get(Dive.class).isDoing();
    }

    @Override
    public void animatePost(Player player, Parkourability parkourability, PlayerModelTransformer transformer) {
        double ySpeed = parkourability.get(Dive.class).getPlayerYSpeed(transformer.getPartialTick());
        float factor = this.getFactor(ySpeed);
        transformer.rotateHeadPitch(-50.0f * factor).rotateRightArm(0.0f, 0.0f, (float)Math.toRadians(195.0f * factor)).rotateLeftArm(0.0f, 0.0f, (float)Math.toRadians(-195.0f * factor)).makeArmsNatural().rotateRightLeg((float)Math.toRadians(-180.0f * (factor - this.oldFactor)), 0.0f, 0.0f).rotateLeftLeg((float)Math.toRadians(-180.0f * (factor - this.oldFactor)), 0.0f, 0.0f);
        this.oldFactor = factor;
    }

    @Override
    public void rotate(Player player, Parkourability parkourability, PlayerModelRotator rotator) {
        double ySpeed = parkourability.get(Dive.class).getPlayerYSpeed(rotator.getPartialTick());
        float factor = this.getFactor(ySpeed);
        rotator.startBasedCenter().rotateFrontward(180.0f * factor).end();
    }
}

